import matplotlib.pyplot as plt

def draw(
        values:list
):
    bar_width = 0.4
    offset = 9

    positions = []
    for i in range(3):
        for j in range(10):
            positions.append((i+1)*offset-3*bar_width+j*2*bar_width)

    color = ['#008000', '#F0E68C', '#808080','#000080' ,'#ADD8E6','#D2B48C','#808000','#DAA520','#C1F80A','#D2691E']
    plt.bar(positions, values, color=color, edgecolor='black', linewidth=2)

    legend_labels = ['OWA', 'R', 'Ada','GOK','EAE','UCB','MOT','MPC', 'S-OWA','A-OWA']
    legend_handles = [plt.Line2D([0], [0], color=color, linewidth=3, linestyle='-') for color in
                      color]
    plt.legend(legend_handles, legend_labels, loc='upper center', bbox_to_anchor=(0.5, 1.15),
               fancybox=True, shadow=True, ncol=5, fontsize=10)

    plt.xlabel(r"$K$ (kJ)", fontsize=12)
    plt.ylabel(r"Accumulated Accuracy", fontsize=12)
    plt.grid(axis='y', linestyle='--', alpha=0.7)

    plt.xticks([(i+1.275)*offset for i in range(3)], ['6', '7', '8'],fontsize=10)
    figure = plt.gcf()
    figure.savefig("Set2-2.pdf")
    plt.show()

if __name__ == '__main__':
    OWA = [198.582121092802, 0, 208.87412037097994, 0.0, 0.0, 216.54660571021634]
    Random = [166.48534300366265, 0.0, 158.490706444778, 0.0, 0.0, 160.19322654322946]
    Adaptive = [126.50111490524588, 0.0, 139.65117402148934, 0.0, 0.0, 162.62092906763434]
    SingleOLS = [167.9893873553747, 0.0, 184.12294650987067, 0.0, 0.0, 195.8844595171273]
    MAB = [79.50795405391118, 0.0, 79.50795405391118, 0.0, 0.0, 79.50795405391118]
    GOK = [92.58151145749879, 0.0, 92.58151145749879, 0.0, 0.0, 92.58151145749879]
    MPC = [92.58151145749879, 0.0, 92.58151145749879, 0.0, 0.0, 163.92876930733027]
    UBC = [114.59474264908765, 0.0, 114.59474264908765, 0.0, 0.0, 114.59474264908765]
    AvgM = [41.13167147858822, 0.0, 41.192987827339266, 0.0, 0.0, 98.0605826234139]
    OTP = [123.64457466339981,0.0,143.67749323035255,0.0,0.0,170.78778424794476]
    rows = [OWA, Random, Adaptive, GOK, MAB, UBC, OTP, MPC, SingleOLS, AvgM]
    data = []
    for j in range(3):
        if j==0:
            for i in rows:
                data.append(i[0])
        if j==2:
            for i in rows:
                data.append(i[-1])
        if j==1:
            for i in rows:
                data.append((i[2]+i[3])/2)
    print(len(data))
    draw(data)